

 
 /***************************************************************************************************************
  *                          Example_1. ET-REMOTE MP3 Trig-Mode By Command RS232                                *
  ***************************************************************************************************************
  *                                                                                                             *
  * Target MCU           : STM8S208MB(ET-BASE STM8S208)                                                         *
  *       	             : USE Internal Clock HSI: 16 MHz                                                       *                                                              
  *                                                                                                             *
  * Editor               : STD V4.1.5                                                                           *
  * Compiler             : COSMIC CXSTM8_16K V4.2.8                                                             *
  * Firmware library     : V1.1.1 update (06/05/2009)                                                           *
  *																				                                                                      *
  * Port Interface       :                                                                                      *
  *																											                                                        *
  *            I/O       : # MCU-STM8S208 #                 # ET-REMOTE MP3 #                                   *
  *                        ----------------                 -----------------                                   *
  *                                                                                                             *                                   
  *                        PB[0..7](OUT)       connect       Trig CH1-CH8                                       *                                        
  *                        PI[0..7](OUT)       connect       Trig CH9-CH16                                      *                            
  *                        GND                 connect       GND                                                *                                                           
  *                                                                                                    		      *
  * UART0(RS232)         : PA4 = Rx1                                                                            *
  *                        PA5 = Tx1			                                                                      *
  *            	           Baud Rate 9600                                                                       *
  * 																									                                                          *
  *                                                                                  -DIP-SW.MODE               *
  *    Sent CMM      3.3V                                                              S1=OFF,S2=OFF            *
  *   Tx1  Rx1      --+--                                                            -DIP-SW.CONFIG             *
  *    ^    ^         |                                                                S1=OFF,S2=ON             *
  *    |    |         |             															                                    			    *
  *    |    |         |                                                          --------------------			      *
  *    |    |   ------+------           Trig Signal CH1-CH8 (Active'0')         |                    |          *
  *    |    |  |         PB0 |--------------------------------------------------|CH1                 |          *
  *    |    +--|PA4       .  |                                                  | .                  |          *
  *    |       |          .  |                                                  | .                  |          *
  *    |       |          .  |                                                  | .                  |          *
  *    +-------|PA5      PB7 |--------------------------------------------------|CH8                 |          *
  *            |             |                                                  |                    |          *
  *            |             |                                                  |   ET-REMOTE MP3V2  |          *
  *            |             |          Trig Signal CH9-CH16 (Active'0')        |                    |          *
  *            |         PI0 |--------------------------------------------------|CH9                 |          *
  *            |          .  |                                                  | .                  |          *
  *            |          .  |                                                  | .                  |          *
  *            |          .  |                                                  | .                  |          *
  *            |         PI7 |--------------------------------------------------|CH16   [Supply]     |          *
  *             ------+------                                                   |       G    5V      |          *
  *                   |STM8S208                                                   -------+-----+------          *
  *                 --+--                                                                |     |                *
  *                  ---                                                                 |     |                *
  *                   -                                                                  |     +-->5V           *
  *                                                                                    --+--                    *
  *                                                                                     ---                     *
  *                                                                                      -                      *
  *                                                                                                             *
  *                                                                                                             *
  *   ASCII Command For Test :  +----------+-------------+---------------+                                      *
  *                             |Start Byte| Number Song |      End      |                                      *
  *                             +----------+-------------+---------------+                                      *
  *                             |  1Byte   |   2Byte     |    1 Byte     |                                      *
  *                             +----------+-------------+---------------+                                      *
  *                             |    *     |    01-16    |  0x0D (Enter) |                                      *
  *                             +----------+-------------+---------------+                                      *
  *                                                                                                             *
  *                                                                                                             *
  * File Libary(src) Add : 1. stm8s_UART1.c                                                                     *
  *                        2. stm8s_gpio.c                                                                      *
  *                        3. stm8s_clk.c                                                                       *
	*                        4. stm8s_tim4.c                                                                      *
  *                                                                                                             *
  *                                                                                                             *
  * Create By            : Mr. Sittiphol Yooyod (WWW.ETT.CO.TH)                                                 *
  * Last Update          : 8/June/2012                                                                          *
  *                                                                                                             *
  ***************************************************************************************************************/

 
#include "stm8s.h"
#include "stdio.h"
 
 unsigned char enter,cmm_cnt=0,cmm_buf[3] ;
 unsigned int counter ;


  /**************************************************************************** 
	 *     <----- Retargets the C library printf function to the UART1. ------> *
   *                                                                          *
   *  Library functions called:                                               *
   *                           - UART1_GetFlagStatus(UART1_FLAG_TC)           *
	 *                           - UART1_SendData8()                            *
   ****************************************************************************/

 char putchar (char c)
  {

    if (c == '\n')
    {
			/* put '\r' to hardware here */
			/* Wait transmission is completed : otherwise the first data is not sent */
			while (!UART1_GetFlagStatus(UART1_FLAG_TC));
			UART1_SendData8('\r');
			/* Wait transmission is completed */
			while (!UART1_GetFlagStatus(UART1_FLAG_TC));
	  }
    /* put c to hardware here */
    /* Wait transmission is completed : otherwise the first data is not sent */
    while (!UART1_GetFlagStatus(UART1_FLAG_TC));
    UART1_SendData8(c);
    /* Wait transmission is completed */
    while (!UART1_GetFlagStatus(UART1_FLAG_TC));


    return (c);
  }


/*************************************************************************
 *  <---- Retargets the C library getchar function from the UART1 ---->  *
 *                                                                       *
 *    Library functions called:                                          *
 *                           - UART1_GetFlagStatus(UART1_FLAG_RXNE)      *
 *                           - UART1_ReceiveData8()                      *
 *************************************************************************/
char getchar (void)
{
	  while (!UART1_GetFlagStatus(UART1_FLAG_RXNE)); //check Read Data Register Not Empty flag
    return (UART1_ReceiveData8())                ;
}


/***************************************************
 *                   Function delay ms 		    	   *
 ***************************************************/

void delay (void)
{
	char i  ;
  for(i=0;i<2;i++){;} 
	  
}


void delay_ms(unsigned int ms)
{ 
	counter=0                     ;
	TIM4_Cmd(ENABLE)              ;     //Start Time4	
  while(counter!= ms){delay();}
	TIM4_Cmd(DISABLE)             ;    //Stop Time4	
	
}



/*************************************************************************
 *            Function Initial Timer4 Control for delay                  *
 *     Max CPU Freq = 16 MHz                                             *
 *     Prescaler to divide Fcpu by = 128                                 *
 *     Freq-Clock = 16MHz/128 =  0.125 MHz= 8 us/clock.                  *
 *************************************************************************/


//------------------------ Initial Timer4 For Delay Interrupt every 1 ms ----------------------

 void Init_Timer4(void)
  {
		TIM4_DeInit()                             ;   //clear overflow flag 
    TIM4_TimeBaseInit(TIM4_PRESCALER_128,125) ;   //Freq master/128 ,Perioid = 125x8us =1 ms
    TIM4_ITConfig(TIM4_IT_UPDATE,ENABLE)      ;   //Enable interrupt
 
	}



 /*********************************************
  *              Initial UART1                *
	*********************************************
	* UART1 configured as follow:               *
  *        - BaudRate = 9600 baud             *
  *        - Word Length = 8 Bits             *
  *        - One Stop Bit                     *
  *        - No parity                        *
  *        - Receive and transmit enabled     *
	*        - UART1 Clock disabled             *
	*                                           *
  *********************************************/

 void Init_UART1(void)
  {
    UART1_DeInit();  //Set the UART1 peripheral registers to their default reset values
		UART1_Init(9600,UART1_WORDLENGTH_8D,UART1_STOPBITS_1,UART1_PARITY_NO,UART1_SYNCMODE_CLOCK_DISABLE,UART1_MODE_TXRX_ENABLE);
    enableInterrupts()                     ;   // Enable general interrupts 
		UART1_ITConfig(UART1_IT_RXNE_OR,ENABLE);   // Enable UART1 Receive Interrupt  
  }
 
 /***********************************************************
 **                     Initial Port                      **
 ***********************************************************/
 
 void Init_Port(void)
 {
	
	 GPIO_DeInit(GPIOB)                                          ;      //CLear PortB
	 GPIO_DeInit(GPIOI)                                          ;      //CLear PortI
	 
	 GPIO_Init(GPIOB,GPIO_PIN_ALL,GPIO_MODE_OUT_PP_HIGH_FAST )   ;      //Initial PB = Output,Level High
	 GPIO_Init(GPIOI,GPIO_PIN_ALL,GPIO_MODE_OUT_PP_HIGH_FAST )   ;      //Initial PI = Output,Level Hugh
	
	
 }
 

 /****************************************************
  **                                                **
  **              Function Read Command             **
  **                                                **
  ****************************************************/ 

void chk_cmm(void)
{
      char cm1,cm2 ; 

     if(enter == 0x0D)                        // Check Enter
     {  
       enter  = 0x00  ;                       // Clear valiable 'enter'
         
         if(cmm_buf[0]== '*')                 // Check Start Byte
          {       
            cm1 = (cmm_buf[1]-0x30)*10    ;   //Convert CMM Ascii to  decimal colum 10
            cm2 = (cmm_buf[2]-0x30)+cm1   ;   //Convert CMM Ascii to  decimal colum 1
                         
                           
              //------------------ Sent Signal Trig Follow Command -----------------------

           switch(cm2)
             {
              case 1 :     //--------------- TRIG-CH1(PB0)-------------

                     cmm_buf[0] = 0xFF     ;    //Clear buffer cmm
                     cmm_buf[1] = 0xFF     ;
                     cmm_buf[2] = 0xFF     ;              
                      
                     GPIO_WriteLow(GPIOB,GPIO_PIN_0)     ;    //PB0=0 : Trig-CH1   

                     delay_ms(20)                        ;    //Delay 20 ms for Trig 0

                     GPIO_WriteHigh(GPIOB,GPIO_PIN_0)    ;    //PB0=1  
				    
                     printf("#OK\n\r")                   ;    //Sent Echo Command 
                   
              break ;

	 
             case 2 :     //--------------- TRIG-CH2(PB1)-------------

                     cmm_buf[0] = 0xFF     ;    //Clear buffer cmm
                     cmm_buf[1] = 0xFF     ;
                     cmm_buf[2] = 0xFF     ;              
                      
										 GPIO_WriteLow(GPIOB,GPIO_PIN_1)    ;    //PB1=0 : Trig-CH2   

                     delay_ms(20)                       ;    //Delay 20 ms for Trig 0

										 GPIO_WriteHigh(GPIOB,GPIO_PIN_1)   ;    //PB1=1  
		
                     printf("#OK\n\r")                  ;    //Sent Echo Command 
				 
              break ;

              case 3 :     //--------------- TRIG-CH3(PB2)-------------

                     cmm_buf[0] = 0xFF     ;    //Clear buffer cmm
                     cmm_buf[1] = 0xFF     ;
                     cmm_buf[2] = 0xFF     ;              
                      
										 GPIO_WriteLow(GPIOB,GPIO_PIN_2)    ;    //PB2=0 : Trig-CH3   
 
                     delay_ms(20)                       ;    //Delay 20 ms for Trig 0

									 	 GPIO_WriteHigh(GPIOB,GPIO_PIN_2)   ;    //PB2=1  
				 	
                     printf("#OK\n\r")                  ;    //Sent Echo Command 
				
              break ;

              case 4 :     //--------------- TRIG-CH4(PB3)-------------

                     cmm_buf[0] = 0xFF     ;    //Clear buffer cmm
                     cmm_buf[1] = 0xFF     ;
                     cmm_buf[2] = 0xFF     ;              
                      
										 GPIO_WriteLow(GPIOB,GPIO_PIN_3)     ;    //PB3=0 : Trig-CH4   

                     delay_ms(20)                        ;    //Delay 20 ms for Trig 0

                     GPIO_WriteHigh(GPIOB,GPIO_PIN_3)    ;    //PB3=1  
 
                     printf("#OK\n\r")                   ;    //Sent Echo Command 
			
              break ;
            
              case 5 :     //--------------- TRIG-CH5(PB4)-------------

                     cmm_buf[0] = 0xFF     ;    //Clear buffer cmm
                     cmm_buf[1] = 0xFF     ;
                     cmm_buf[2] = 0xFF     ;              
                      
										 GPIO_WriteLow(GPIOB,GPIO_PIN_4)     ;    //PB4=0 : Trig-CH5   

                     delay_ms(20)                        ;    //Delay 20 ms for Trig 0

										 GPIO_WriteHigh(GPIOB,GPIO_PIN_4)    ;    //PB4=1  

                     printf("#OK\n\r")                   ;    //Sent Echo Command 
				 
              break ;
            
              case 6 :     //--------------- TRIG-CH6(PB5)-------------

                     cmm_buf[0] = 0xFF     ;    //Clear buffer cmm
                     cmm_buf[1] = 0xFF     ;
                     cmm_buf[2] = 0xFF     ;              
                      
                     GPIO_WriteLow(GPIOB,GPIO_PIN_5)     ;    //PB5=0 : Trig-CH6  

                     delay_ms(20)                        ;    //Delay 20 ms for Trig 0

										 GPIO_WriteHigh(GPIOB,GPIO_PIN_5)    ;    //PB5=1  
              
                     printf("#OK\n\r")                   ;    //Sent Echo Command 
		
              break ;
   
              case 7 :     //--------------- TRIG-CH7(PB6)-------------

                     cmm_buf[0] = 0xFF     ;    //Clear buffer cmm
                     cmm_buf[1] = 0xFF     ;
                     cmm_buf[2] = 0xFF     ;              
                      
                     GPIO_WriteLow(GPIOB,GPIO_PIN_6)     ;    //PB6=0 : Trig-CH7   

                     delay_ms(20)                        ;    //Delay 20 ms for Trig 0

										 GPIO_WriteHigh(GPIOB,GPIO_PIN_6)    ;    //PB6=1  
                  
                     printf("#OK\n\r")                   ;    //Sent Echo Command 
				 
              break ;

              case 8 :     //--------------- TRIG-CH8(PB7)-------------

                     cmm_buf[0] = 0xFF     ;    //Clear buffer cmm
                     cmm_buf[1] = 0xFF     ;
                     cmm_buf[2] = 0xFF     ;              
                      
                     GPIO_WriteLow(GPIOB,GPIO_PIN_7)     ;    //PB7=0 : Trig-CH8   

                     delay_ms(20)                        ;    //Delay 20 ms for Trig 0

										 GPIO_WriteHigh(GPIOB,GPIO_PIN_7)    ;    //PB7=1  
 
                     printf("#OK\n\r")                   ;    //Sent Echo Command 
				   
              break ;


            
              case 9 :     //--------------- TRIG-CH9(PI0)-------------

                     cmm_buf[0] = 0xFF     ;    //Clear buffer cmm
                     cmm_buf[1] = 0xFF     ;
                     cmm_buf[2] = 0xFF     ;              
         
            				 GPIO_WriteLow(GPIOI,GPIO_PIN_0)     ;    //PB0=0 : Trig-CH9   

                     delay_ms(20)                        ;    //Delay 20 ms for Trig 0

										 GPIO_WriteHigh(GPIOI,GPIO_PIN_0)    ;    //PB0=1  
										 
                     printf("#OK\n\r")                   ;    //Sent Echo Command 
				 
              break ;


             case 10 :     //--------------- TRIG-CH10(PI1)-------------

                     cmm_buf[0] = 0xFF     ;    //Clear buffer cmm
                     cmm_buf[1] = 0xFF     ;
                     cmm_buf[2] = 0xFF     ;              
                      
                    
            				 GPIO_WriteLow(GPIOI,GPIO_PIN_1)     ;    //PI1=0 : Trig-CH10   

                     delay_ms(20)                        ;    //Delay 20 ms for Trig 0

										 GPIO_WriteHigh(GPIOI,GPIO_PIN_1)    ;    //PI1=1  

                     printf("#OK\n\r")                   ;    //Sent Echo Command 
				   
              break ;


             case 11 :     //--------------- TRIG-CH11(PI2)-------------

                     cmm_buf[0] = 0xFF     ;    //Clear buffer cmm
                     cmm_buf[1] = 0xFF     ;
                     cmm_buf[2] = 0xFF     ;              
                      
            				 GPIO_WriteLow(GPIOI,GPIO_PIN_2)     ;    //PI2=0 : Trig-CH11   

                     delay_ms(20)                        ;    //Delay 20 ms for Trig 0

										 GPIO_WriteHigh(GPIOI,GPIO_PIN_2)    ;    //PI2=1  
    
                     printf("#OK\n\r")                   ;    //Sent Echo Command 
				   
              break ;


            case 12 :     //--------------- TRIG-CH12(PI3)-------------

                     cmm_buf[0] = 0xFF     ;    //Clear buffer cmm
                     cmm_buf[1] = 0xFF     ;
                     cmm_buf[2] = 0xFF     ;              
                      
                   
            				 GPIO_WriteLow(GPIOI,GPIO_PIN_3)     ;    //PI3=0 : Trig-CH12   

                     delay_ms(20)                        ;    //Delay 20 ms for Trig 0

										 GPIO_WriteHigh(GPIOI,GPIO_PIN_3)    ;    //PI3=1  

                     printf("#OK\n\r")                   ;    //Sent Echo Command 
				  
		      break;

            case 13 :     //--------------- TRIG-CH13(PI4)-------------

                     cmm_buf[0] = 0xFF     ;    //Clear buffer cmm
                     cmm_buf[1] = 0xFF     ;
                     cmm_buf[2] = 0xFF     ;              
                   
 									   GPIO_WriteLow(GPIOI,GPIO_PIN_4)     ;    //PI4=0 : Trig-CH13   

                     delay_ms(20)                        ;    //Delay 20 ms for Trig 0

										 GPIO_WriteHigh(GPIOI,GPIO_PIN_4)    ;    //PI4=1  

                     printf("#OK\n\r")                   ;    //Sent Echo Command 

              break ;



            case 14 :     //--------------- TRIG-CH14(PI5)-------------

                     cmm_buf[0] = 0xFF     ;    //Clear buffer cmm
                     cmm_buf[1] = 0xFF     ;
                     cmm_buf[2] = 0xFF     ;              
          
										 GPIO_WriteLow(GPIOI,GPIO_PIN_5)     ;    //PI5=0 : Trig-CH14   

                     delay_ms(20)                        ;    //Delay 20 ms for Trig 0

										 GPIO_WriteHigh(GPIOI,GPIO_PIN_5)    ;    //PI5=1  


                     printf("#OK\n\r")                   ;    //Sent Echo Command 
					  
              break ;


             case 15 :     //--------------- TRIG-CH15(PI6)-------------

                     cmm_buf[0] = 0xFF     ;    //Clear buffer cmm
                     cmm_buf[1] = 0xFF     ;
                     cmm_buf[2] = 0xFF     ;              
                      
										 GPIO_WriteLow(GPIOI,GPIO_PIN_6)     ;    //PI6=0 : Trig-CH115   

                     delay_ms(20)                        ;    //Delay 20 ms for Trig 0

										 GPIO_WriteHigh(GPIOI,GPIO_PIN_6)    ;    //PI6=1  


                     printf("#OK\n\r")                   ;    //Sent Echo Command 
				
              break ;


             case 16 :     //--------------- TRIG-CH17(PI7)-------------

                     cmm_buf[0] = 0xFF     ;    //Clear buffer cmm
                     cmm_buf[1] = 0xFF     ;
                     cmm_buf[2] = 0xFF     ;              
                
										 GPIO_WriteLow(GPIOI,GPIO_PIN_7)     ;    //PI7=0 : Trig-CH16   

                     delay_ms(20)                        ;    //Delay 20 ms for Trig 0

										 GPIO_WriteHigh(GPIOI,GPIO_PIN_7)    ;    //PI7=1  

                     printf("#OK\n\r")                   ;    //Sent Echo Command 
				
              break ;
             
            }   // if switch
          } // if cmm
       }  // if enter


}


//####################----- Main Program -----#######################

main(void)
 {
	 
	 CLK_HSIPrescalerConfig(CLK_PRESCALER_HSIDIV1)              ;      //Set High speed internal Clock = 16MHZ = FhsiDiv=Fmaster=Fcpu 
	 
	 Init_Port()       ;
   Init_Timer4()     ;
   Init_UART1()      ;

   delay_ms(1000)    ;       //delay for Sync Borad MP3 Ready 

	 printf("########### ET-REMOTE MP3 V2. ==> PLAY TRIG MODE #########\n\r") ;

   while(1)
   {    
     chk_cmm() ;
   }   
 

 }  











#ifdef USE_FULL_ASSERT

/**
  * @brief  Reports the name of the source file and the source line number
  *   where the assert_param error has occurred.
  * @param file: pointer to the source file name
  * @param line: assert_param error line source number
  * @retval : None
  */
void assert_failed(u8* file, u32 line)
{ 
  /* User can add his own implementation to report the file name and line number,
     ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

  /* Infinite loop */
  while (1)
  {
  }
}
#endif






